CONTAINER fx_fluidsim
{
	NAME fx_fluidsim;
	INCLUDE Obase;
		
	GROUP ID_OBJECTPROPERTIES
	{
		DEFAULT 1;
		LONG FLUIDSIM_SIMULATIONTYPE
		{
			CYCLE
			{
				FLUIDSIM_SIMULATIONTYPE_AIR;
				FLUIDSIM_SIMULATIONTYPE_SMOKE;
				FLUIDSIM_SIMULATIONTYPE_FIRE;
				FLUIDSIM_SIMULATIONTYPE_COMBUSTION;
				FLUIDSIM_SIMULATIONTYPE_WATER;
				FLUIDSIM_SIMULATIONTYPE_VISCOSITY;
			}				
		}		
		SEPARATOR {LINE;}
		GROUP
		{
			DEFAULT 1;
			GROUP
			{
				COLUMNS 3;
				BUTTON FLUIDSIM_ADDFLUIDOBJECT {}
				BUTTON FLUIDSIM_ADDFLUIDOBJECTBDR {}
				BUTTON FLUIDSIM_ADDFLUIDOBJECTEVENT {}
			}
			IN_EXCLUDE FLUIDSIM_OBJECTLIST
			{
				NUM_FLAGS 0; INIT_STATE 0; SEND_SELCHNGMSG 1;
				ACCEPT {  fx_fluidobj; };
			}				
		}
		GROUP FLUIDSIM_SEP_GLOBALDOMAIN
		{
			DEFAULT 1;
			LONG FLUIDSIM_SPACEMODE
			{
				CYCLE
				{
					FLUIDSIM_SPACEMODE_SIMPLE;
					FLUIDSIM_SPACEMODE_CDIM;
					FLUIDSIM_SPACEMODE_CDIMCELLS;					
				}
				ANIM OFF;
			}
			LONG FLUIDSIM_ADAPTIVEGRID {MIN 0; MAX 20;}
			VECTOR FLUIDSIM_GRIDSIZE {MIN 0.001 0.001 0.001; UNIT METER;ANIM OFF;}
			VECTOR FLUIDSIM_GRIDCELLS {MIN 1 1 1; MAX 3000 3000 3000; ANIM OFF;} 
			VECTOR FLUIDSIM_GRIDCELLS_RENDER {MIN 1 1 1; MAX 3000 3000 3000;ANIM OFF;}
			REAL FLUIDSIM_VOXELDIM {ANIM OFF; MIN 0.001; STEP 0.1; CUSTOMGUI DOUBLE; DUNIT DUNIT_METER;}
			REAL FLUIDSIM_VOXELSIZE {ANIM OFF; MIN 0.001; STEP 0.1;}
			BOOL FLUIDSIM_KEEPSCALE {ANIM OFF; }
				
			SEPARATOR {LINE;}

			BOOL FLUIDSIM_SHOWINFO {ANIM OFF;}
			STATICTEXT FLUIDSIM_CELLS_CNT {ANIM OFF;}
			STATICTEXT FLUIDSIM_CELLS_CNT_R {ANIM OFF;}
			STATICTEXT FLUIDSIM_MEMORY_R {ANIM OFF;}

			SEPARATOR {LINE;}
				
			STATICTEXT FLUIDSIM_CELLS_CNTSUB {ANIM OFF;}
			STATICTEXT FLUIDSIM_CELLS_CNT_RSUB {ANIM OFF;}
			STATICTEXT FLUIDSIM_MEMORY_RSUB {ANIM OFF;}
		}
		GROUP FLUIDSIM_SEP_GLOBALSIMULATION
		{
			DEFAULT 1;
			GROUP
			{
				COLUMNS 2;				
				LONG FLUIDSIM_USESCENESTEP
				{
					CYCLE
					{
						FLUIDSIM_USESCENESTEP_AUTO;
						FLUIDSIM_USESCENESTEP_AUTOFRAME;
						FLUIDSIM_USESCENESTEP_CUSTOM;
					}
				}
				SEPARATOR {}
				REAL FLUIDSIM_TIMESTEP { MIN 0.00001; MAX 10.0;  STEP 0.01; CUSTOMGUI DOUBLE; DUNIT DUNIT_SEC; DDIGITS 6;}
				LONG FLUIDSIM_SUBTIMESTEPS {MIN 0; MAX 100; }
			}
			SEPARATOR {LINE;}
			GROUP
			{
				COLUMNS 3;
				BOOL FLUIDSIM_AUTOTIME {}
				LONG FLUIDSIM_FROM {MIN 0; }
				LONG FLUIDSIM_TO {MIN 1;}
			}
		}
		GROUP FLUIDSIM_PRESETS_G
		{
			LONG FLUIDSIM_PRESETS
			{
				CYCLE
				{
					FLUIDSIM_PRESETS_DEFAULT;
				}
			}
			GROUP
			{
			COLUMNS 4;
			BUTTON FLUIDSIM_PRESETS_SET {}
			BUTTON FLUIDSIM_PRESETS_SAVE {}
			BUTTON FLUIDSIM_PRESETS_SAVEAS {}
			BUTTON FLUIDSIM_PRESETS_DE {}
			}
		}
	}
	GROUP ID_FLUID_G
	{
		GROUP ID_FLUIDCACHE_SID
		{	
			LONG   FLUIDSIM_FLUIDCACHE_MODE 
			{
				CYCLE
				{
					FLUIDSIM_FLUIDCACHE_MODE_OFF;
					FLUIDSIM_FLUIDCACHE_MODE_FILE;
					//FLUIDSIM_FLUIDCACHE_MODE_RAM;
				}
			}
			BUTTON FLUIDSIM_FLUIDCACHE_SELECTFOLDER {}
			STRING FLUIDSIM_FLUIDCACHE_FILENAME {ANIM OFF;}
			STRING FLUIDSIM_FLUIDCACHE_FILENAME_NAME {ANIM OFF;}
			BOOL FLUIDSIM_FLUIDCACHE_PARTICLES {}
			BOOL FLUIDSIM_FLUIDCACHE_RENDERONLY {HIDDEN;}

			SEPARATOR {LINE;}

			BOOL FLUIDSIM_FLUIDCACHE_STARTFRAME {}
			GROUP
			{
				COLUMNS 2;
				LONG FLUIDSIM_FLUIDCACHE_FRAME {MIN -1;}
				REAL FLUIDSIM_FLUIDCACHE_BLEND {MIN 0; MAX 100; UNIT PERCENT; CUSTOMGUI REALSLIDER;}
			}
		}
		SEPARATOR {LINE;}
		
		LONG FLUIDSIM_WATER_SIMTYPE
		{
			ANIM OFF; HIDDEN;
			CYCLE
			{
				FLUIDSIM_WATER_SIMTYPE_PARTICLEGRID;
				FLUIDSIM_WATER_SIMTYPE_PARTICLES;
			}
		}
		LONG FLUIDSIM_WATER_LEVELSET
		{
			HIDDEN;
			CYCLE
			{
				FLUIDSIM_WATER_LEVELSET_SIMPLE;
				FLUIDSIM_WATER_LEVELSET_SPHERE;
			}
		}
		SEPARATOR {LINE;}
		LONG FLUIDSIM_WATER_FLIPMODE
		{
			ANIM OFF;
			CYCLE
			{
				FLUIDSIM_WATER_FLIPMODE_FLIP;
				FLUIDSIM_WATER_FLIPMODE_HFAFLIP;
			}
		}
		REAL FLUIDSIM_WATER_PICFLIP { MIN 0.0; MAX 100; }
		BOOL FLUIDSIM_WATER_RELATIVEVISCOSITY { }
		
		REAL FLUIDSIM_WATER_HFA_ZONEFACTOR { MIN 0.0; MAX 4.0; STEP 0.01;}
		REAL FLUIDSIM_WATER_HFA_THRESHOLD_VELOCITY { MIN 0.0; MAX 10000; STEP 0.5;}
		LONG FLUIDSIM_WATER_HFA_THRESHOLD_PARTICLES { MIN 1; }
		LONG FLUIDSIM_WATER_HFA_THRESHOLD_ZONECELLS { MIN 1; }

		SEPARATOR {LINE;}

		LONG FLUIDSIM_WATER_FLIP_SUBTYPE
		{
			ANIM OFF;
			CYCLE
			{
				FLUIDSIM_WATER_FLIP_SUBTYPE_DEFAULT;
				FLUIDSIM_WATER_FLIP_SUBTYPE_COLORED;
			}
		}

		BOOL FLUIDSIM_ENCODE_AGE {ANIM OFF;}
		BOOL FLUIDSIM_ENCODE_VISCOSITY {ANIM OFF;}
		BOOL FLUIDSIM_ENCODE_DENSITY {ANIM OFF;}
		BOOL FLUIDSIM_ENCODE_COLORFLIP {ANIM OFF;}
		BOOL FLUIDSIM_ENCODE_RADIUS  {ANIM OFF;}
		
		SEPARATOR {LINE;}

		REAL FLUIDSIM_VISCOSITY { MIN 0.0; MAX 1000000.0; STEP 0.000001; CUSTOMGUI DOUBLE; DUNIT DUNIT_SQR_METER_PSEC; DSIZE 70; DDIGITS 6; }
		REAL FLUIDSIM_AIRDENSITY {MIN 0.01; MAX 100000; STEP 0.1; CUSTOMGUI DOUBLE; DUNIT DUNIT_KG_PCUB_METER; DSIZE 70; DDIGITS 2;}	
		REAL FLUIDSIM_VELOCITYDAMPING { MIN 0.0; MAX 100; UNIT PERCENT;}
		LONG FLUIDSIM_VELOCITYDAMPING_ITERATION { MIN 1; MAX 100; }

		GROUP SID_FLUIDSIM_SOLVERDETAILS
		{
			LONG FLUIDSIM_SOLVERTYPE 
			{
				CYCLE
				{
					FLUIDSIM_SOLVERTYPE_CG;
					FLUIDSIM_SOLVERTYPE_GAUSS;
				}
			}

			BOOL FLUIDSIM_AUTOITERATIONS {}
			LONG FLUIDSIM_MAXITERATIONS { MIN 2; MAX 1000; }
			LONG FLUIDSIM_SOLVERACCURACY 
			{
				CYCLE
				{
					FLUIDSIM_SOLVERACCURACY_1E3;
					FLUIDSIM_SOLVERACCURACY_1E4;
					FLUIDSIM_SOLVERACCURACY_1E5;
					FLUIDSIM_SOLVERACCURACY_1E6;
					FLUIDSIM_SOLVERACCURACY_1E7;
					FLUIDSIM_SOLVERACCURACY_1E8;
					FLUIDSIM_SOLVERACCURACY_1E10;
					FLUIDSIM_SOLVERACCURACY_1E12;
					FLUIDSIM_SOLVERACCURACY_1E16;
				}
			}
			LONG FLUIDSIM_MPEDITOR {MIN 1;}
			LONG FLUIDSIM_MPRENDER {MIN 1;}
		}

		BOOL FLUIDSIM_CONVECT_FLUID {}
		BOOL FLUIDSIM_BOUNDARY_CHECKADVECT {}
		BOOL FLUIDSIM_CLEAR_FLUID {}
		SEPARATOR {LINE;}
		LONG FLUIDSIM_TRANSPORTTYPE_FLUID 
		{
			CYCLE
			{
			FLUIDSIM_TRANSPORTTYPE_FLUID_1ST;
			FLUIDSIM_TRANSPORTTYPE_FLUID_2ND;
			FLUIDSIM_TRANSPORTTYPE_FLUID_MIX;
			FLUIDSIM_TRANSPORTTYPE_FLUID_MIXPHASES;
			}
		}
		REAL FLUIDSIM_TMIX_FLUID {MIN 0; MAX 100; UNIT PERCENT; CUSTOMGUI REALSLIDER;}	
		LONG FLUIDSIM_TMIX_BASEA 
		{
			HIDDEN;
			CYCLE
			{
				FLUIDSIM_TMIX_BASEA_SMOKE;
				FLUIDSIM_TMIX_BASEA_HEAT;
				FLUIDSIM_TMIX_BASEA_FIRE;
				FLUIDSIM_TMIX_BASEA_FUEL;
			}
		}
		REAL FLUIDSIM_TMIXB_FLUID {MIN 0; MAX 100; UNIT PERCENT; CUSTOMGUI REALSLIDER;}
		SEPARATOR {LINE;}

		LONG FLUIDSIM_TRACEALGO
		{
			CYCLE
			{
			FLUIDSIM_TRACEALGO_EULER1ST;
			FLUIDSIM_TRACEALGO_RUNGA2ND;
			FLUIDSIM_TRACEALGO_RUNGA3RD;
			FLUIDSIM_TRACEALGO_RUNGA4TH;
			}
		}
		LONG FLUIDSIM_ALGO
		{
			CYCLE
			{
				FLUIDSIM_ALGO_LINEAR;
				FLUIDSIM_ALGO_COSINE;
				FLUIDSIM_ALGO_HERMITE;
			}
		}

		SEPARATOR {LINE;}

		LONG FLUIDSIM_TRACEALGO_FLIP
		{
			CYCLE
			{
			FLUIDSIM_TRACEALGO_FLIP_EULER1ST;
			FLUIDSIM_TRACEALGO_FLIP_RUNGA2ND;
			FLUIDSIM_TRACEALGO_FLIP_RUNGA3RD;
			FLUIDSIM_TRACEALGO_FLIP_RUNGA4TH;
			}
		}
		LONG FLUIDSIM_SUBSTEPS_FLIP {MIN 0; }
		BOOL FLUIDSIM_FLIPPARTICLES_CHECKADVECT {}
	}
	GROUP ID_SIMULATION_FX_G
	{	
		GROUP
		{
			COLUMNS 4;
			LONG FLUIDSIM_CHANNEL_BOUNDARIES {ANIM OFF; CUSTOMGUI VISIBILITY; BOOLEAN;}
			LONG FLUIDSIM_CHANNEL_FORCES {ANIM OFF; CUSTOMGUI VISIBILITY; BOOLEAN;}
			LONG FLUIDSIM_CHANNEL_TURBULENCE {ANIM OFF; CUSTOMGUI VISIBILITY; BOOLEAN;}
			LONG FLUIDSIM_CHANNEL_SIMMIX {ANIM OFF; CUSTOMGUI VISIBILITY; BOOLEAN;}
		}
		SEPARATOR { LINE; }

		GROUP FlUIDSIM_BOUNDARY_SID
		{		
			DEFAULT 1;
			GROUP
			{	
				DEFAULT 1;COLUMNS 6;
				LONG FLUIDSIM_BRD_LEFT		{MIN 0; MAX 1; CUSTOMGUI VISIBILITY; BOOLEAN; ISBIT; BITS 1; BNAME BNAME_LEFT; ANIM OFF;}
				LONG FLUIDSIM_BRD_RIGHT		{MIN 0; MAX 1; CUSTOMGUI VISIBILITY; BOOLEAN; ISBIT; BITS 2; BNAME BNAME_RIGHT; ANIM OFF;}
				LONG FLUIDSIM_BRD_BOTTOM	{MIN 0; MAX 1; CUSTOMGUI VISIBILITY; BOOLEAN; ISBIT; BITS 3; BNAME BNAME_BOTTOM; ANIM OFF;}
				LONG FLUIDSIM_BRD_TOP		{MIN 0; MAX 1; CUSTOMGUI VISIBILITY; BOOLEAN; ISBIT; BITS 4; BNAME BNAME_TOP; ANIM OFF;}
				LONG FLUIDSIM_BRD_FRONT		{MIN 0; MAX 1; CUSTOMGUI VISIBILITY; BOOLEAN; ISBIT; BITS 5; BNAME BNAME_FRONT; ANIM OFF;}
				LONG FLUIDSIM_BRD_BACK		{MIN 0; MAX 1; CUSTOMGUI VISIBILITY; BOOLEAN; ISBIT; BITS 6; BNAME BNAME_BACK; ANIM OFF;}			
			}
			LONG FLUIDSIM_BOUNDARY_SLIP 
			{
				CYCLE
				{
					FLUIDSIM_BOUNDARY_SLIP_FREE;
					FLUIDSIM_BOUNDARY_SLIP_NO;
				}
			}
			REAL FLUIDSIM_BOUNDARY_FREESLIP {MIN 0; MAX 100; UNIT PERCENT; HIDDEN;}
				
			SEPARATOR {LINE;}
				
			BOOL FLUIDSIM_BODYFORCES {}
			LONG FLUIDSIM_OBSTACLE_SLIP
			{
				CYCLE
				{
					FLUIDSIM_OBSTACLE_SLIP_FREE;
					FLUIDSIM_OBSTACLE_SLIP_NO;
				}
			}
			REAL FLUIDSIM_OBSTACLE_FREESLIP {MIN 0; MAX 100; UNIT PERCENT; }
			LONG FLUIDSIM_EXTRAPOLATION_LAYERS {MIN 1; MAX 10;}
			LONG FLUIDSIM_BODYFORCES_ITERATIONS {MIN 1; MAX 10;}
			REAL FLUIDSIM_BODYFORCES_DIFFUSION  {MIN 0; MAX 3; STEP 0.1; }
			
			SEPARATOR {LINE;}

			LONG FLUIDSIM_OBSTACLE_FRCTQUALITY
			{
				CYCLE
				{
					FLUIDSIM_OBSTACLE_FRCTQUALITY_1;
					FLUIDSIM_OBSTACLE_FRCTQUALITY_2;
					FLUIDSIM_OBSTACLE_FRCTQUALITY_3;
					FLUIDSIM_OBSTACLE_FRCTQUALITY_4;
				}
			}
		}
		GROUP ID_SLAVES_G
		{
			DEFAULT 1;
			BOOL FLUIDSIM_CHANNEL_XPFORCE {ANIM OFF; }
			VECTOR FLUIDSIM_GGRAVITY {STEP 0.01; }
			
			GROUP ID_BUOYANCY_SID
			{
				DEFAULT 1;
				LONG FLUIDSIM_BOUYANCY_FEATURES
				{
					CYCLE
					{
						FLUIDSIM_BOUYANCY_NORMAL;
						FLUIDSIM_BOUYANCY_GRADIENT;
					}
				}
				VECTOR FLUIDSIM_BOUYANCY_DIR {MIN -1 -1 -1; MAX 1 1 1; STEP 0.01;}
				REAL FLUIDSIM_BOUYANCY {MIN -100; MAX 100; STEP 0.001;}	
				REAL FLUIDSIM_GRAVITY {STEP 0.01;}	
				BOOL FLUIDSIM_BOUYANCY_DIRECT {}
				LONG FLUIDSIM_BOUYANCY_GRADAXIS
				{
					CYCLE
					{
						FLUIDSIM_BOUYANCY_GRADAXIS_X;
						FLUIDSIM_BOUYANCY_GRADAXIS_Y;
						FLUIDSIM_BOUYANCY_GRADAXIS_Z;
					}
				}
				GRADIENT FLUIDSIM_BOUYANCY_GRAD {ALPHA; ANIM ON;}
			}
			GROUP ID_EXTERNAL_SID
			{
				DEFAULT 0;
				REAL FLUIDSIM_C4DFORCE_GLOBALIMPACT {MIN 0; MAXSLIDER 100; UNIT PERCENT; CUSTOMGUI REALSLIDER;}
				BOOL FLUIDSIM_C4DFORCE_ABSOLUTE {}
				IN_EXCLUDE FLUIDSIM_C4DFORCELIST
				{
					NUM_FLAGS 0; INIT_STATE 0; SEND_SELCHNGMSG 1;
					ACCEPT { Oattractor; Odeflector; Ogravitation; Orotation; Owind;Ofriction;Oturbulence; Odestructor; fx_fluidmodifier;};
				}	
			}		
		}	
		GROUP ID_VORTICITY_G
		{	
			DEFAULT 1;
			LONG FLUIDSIM_GRIDCELLS_SUBDIVISION_EDITOR {MIN 0; MAX 4;ANIM OFF;}
			LONG FLUIDSIM_GRIDCELLS_SUBDIVISION {MIN 0; MAX 4;ANIM OFF;}
			BOOL FLUIDSIM_SUBDIVISION_ONLYRENDER {ANIM OFF;}
			BOOL FLUIDSIM_SUBDIVISION_ONLYLASTLAYER {ANIM OFF;}
			LONG FLUIDSIM_SUBDIVISION_TYPE
			{
				CYCLE
				{
					FLUIDSIM_SUBDIVISION_TYPE_LINEAR;
					FLUIDSIM_SUBDIVISION_TYPE_COSINE;
					FLUIDSIM_SUBDIVISION_TYPE_CUBIC;
				}
				ANIM OFF;
			}
			GROUP FLUIDSIM_VORTICITY_PARTICLES_SID
			{
				DEFAULT 1;
				BOOL FLUIDSIM_VORTICITY_CHECKADVECT {}
				LONG FLUIDSIM_SUBSTEPS_VP {MIN 0; MAX 1000;}
				LONG FLUIDSIM_TRACEALGO_VP
				{
					CYCLE
					{
					FLUIDSIM_TRACEALGO_VP_EULER1ST;
					FLUIDSIM_TRACEALGO_VP_RUNGA2ND;
					FLUIDSIM_TRACEALGO_VP_RUNGA3RD;
					FLUIDSIM_TRACEALGO_VP_RUNGA4TH;
					}
				}
				LONG FLUIDSIM_VORTEXSUBD_TRANSPORT 
				{
					CYCLE
					{
						FLUIDSIM_VORTEXSUBD_TRANSPORT_LOW;
						FLUIDSIM_VORTEXSUBD_TRANSPORT_HIGH;
						FLUIDSIM_VORTEXSUBD_TRANSPORT_LOWHIGH;
					}
				}
			}
			GROUP FlUIDSIM_SUBDIVISION_SID
			{
				DEFAULT 1;
				LONG FLUIDSIM_USEVORTEX 
				{
					CYCLE
					{
						FLUIDSIM_VORTICITY_GLOBAL;
						FLUIDSIM_VORTICITY_GRADIENT;
						FLUIDSIM_VORTICITY_VORTEX;
					}
				}
				SEPARATOR {LINE;}
				LONG FLUIDSIM_VORTICITY_DEPENDENCY
				{
					CYCLE
					{
						FLUIDSIM_VORTICITY_DEPENDENCY_OFF;
						FLUIDSIM_VORTICITY_DEPENDENCY_MAGNITUDE;
						FLUIDSIM_VORTICITY_DEPENDENCY_SMOKE;
						FLUIDSIM_VORTICITY_DEPENDENCY_HEAT;
						FLUIDSIM_VORTICITY_DEPENDENCY_VORTICITY;
						FLUIDSIM_VORTICITY_DEPENDENCY_BDR_DISTANCE;
					}
				}
				REAL FLUIDSIM_VORTICITY_DEPENDENCY_DENSITYLIMIT { MIN 0.0; MAX 100.0; UNIT PERCENT;}
				REAL FLUIDSIM_VORTICITY_DEPENDENCY_VORTICITYLIMIT { MIN 0.0; UNIT METER;}
				REAL FLUIDSIM_VORTICITY_DEPENDENCY_DISTANCELIMIT { MIN 0.0; MAX 10.0;}
				SEPARATOR {LINE;}
				REAL FLUIDSIM_VORTICITY { MIN 0.0; MAX 100000.0; STEP 0.01;}
				LONG FLUIDSIM_VORTICITY_AMP {MIN 1; MAX 10; }
				REAL FLUIDSIM_VORTICITY_RADIUS {MIN 1;}			
				REAL FLUIDSIM_STRETCHLENGTH { MIN 0.0; MAX 200.0; STEP 0.001;}
				BOOL FLUIDSIM_VORTICITYPARTICLES_IPOLEMISSION {HIDDEN;}
				LONG FLUIDSIM_VORTKERNEL
				{
					CYCLE
					{
						FLUIDSIM_VORTKERNEL_STANDARD;
						FLUIDSIM_VORTKERNEL_GAUSSAIN;
						FLUIDSIM_VORTKERNEL_POLY;
						FLUIDSIM_VORTKERNEL_SPIKE;
						FLUIDSIM_VORTKERNEL_SMOOTH;
						FLUIDSIM_VORTKERNEL_CUSTOM;
					}
				}
				REAL FLUIDSIM_VORTKERNEL_LENGTH { MIN 0.001; }

				SPLINE FLUIDSIM_CUSTOMKERNEL
				{
					SHOWGRID_H; 
														  
					X_MIN 0; 
					X_MAX 1; 
										  
					Y_MIN 0; 
					Y_MAX 1; 
										  
					X_STEPS 0.01; 
					Y_STEPS 0.01; 
				}		
				BOOL FLUIDSIM_VORTICITY_DIRECT {}
				LONG FLUIDSIM_VORTICITY_GRADAXIS
				{
					CYCLE
					{
						FLUIDSIM_VORTICITY_GRADAXIS_X;
						FLUIDSIM_VORTICITY_GRADAXIS_Y;
						FLUIDSIM_VORTICITY_GRADAXIS_Z;
					}
				}
				GRADIENT FLUIDSIM_VORTICITY_GRAD {ALPHA; ANIM ON;}			
			}
			GROUP FlUIDSIM_SUBDIVISION_L1_SID
			{
				LONG FLUIDSIM_VORTEX_SUBGRIDLAYER_L1
				{
					CYCLE
					{	
						FLUIDSIM_VORTEX_SUBGRIDLAYER_L1_PARENT;
					}
				}
				SEPARATOR {LINE;}
				LONG FLUIDSIM_VORTICITY_DEPENDENCY_L1
				{
					CYCLE
					{
						FLUIDSIM_VORTICITY_DEPENDENCY_OFF_L1;
						FLUIDSIM_VORTICITY_DEPENDENCY_MAGNITUDE_L1;
						FLUIDSIM_VORTICITY_DEPENDENCY_SMOKE_L1;
						FLUIDSIM_VORTICITY_DEPENDENCY_HEAT_L1;
						FLUIDSIM_VORTICITY_DEPENDENCY_VORTICITY_L1;
						FLUIDSIM_VORTICITY_DEPENDENCY_BDR_DISTANCE_L1;
					}
				}
				REAL FLUIDSIM_VORTICITY_DEPENDENCY_DENSITYLIMIT_L1 { MIN 0.0; MAX 100.0; UNIT PERCENT;}
				REAL FLUIDSIM_VORTICITY_DEPENDENCY_VORTICITYLIMIT_L1 { MIN 0.0; UNIT METER;}
				REAL FLUIDSIM_VORTICITY_DEPENDENCY_DISTANCELIMIT_L1 { MIN 0.0; MAX 10.0;}
				SEPARATOR {LINE;}
				REAL FLUIDSIM_VORTICITYHRES { MIN -100000.0; MAX 100000.0; STEP 0.01;}
				REAL FLUIDSIM_VORTICITY_RADIUS_L1 {MIN 1;}
				REAL FLUIDSIM_STRETCHLENGTH_L1 { MIN 0.001; MAX 2000000.0; STEP 0.001;}
				BOOL FLUIDSIM_VORTICITYPARTICLES_IPOLEMISSION_L1 {HIDDEN;}
				LONG FLUIDSIM_VORTKERNEL_L1
				{
					CYCLE
					{
						FLUIDSIM_VORTKERNEL_L1_STANDARD;
						FLUIDSIM_VORTKERNEL_L1_GAUSSAIN;
						FLUIDSIM_VORTKERNEL_L1_POLY;
						FLUIDSIM_VORTKERNEL_L1_SPIKE;
						FLUIDSIM_VORTKERNEL_L1_SMOOTH;
						FLUIDSIM_VORTKERNEL_L1_CUSTOM;
					}
				}
				REAL FLUIDSIM_VORTKERNEL_LENGTH_L1 { MIN 0.001; }
				SPLINE FLUIDSIM_CUSTOMKERNEL_L1
				{
					SHOWGRID_H; 
														  
					X_MIN 0; 
					X_MAX 1; 
										  
					Y_MIN 0; 
					Y_MAX 1; 
										  
					X_STEPS 0.01; 
					Y_STEPS 0.01; 
				}			
			}
			GROUP FlUIDSIM_SUBDIVISION_L2_SID
			{
				LONG FLUIDSIM_VORTEX_SUBGRIDLAYER_L2
				{
					CYCLE
					{	
						FLUIDSIM_VORTEX_SUBGRIDLAYER_L2_PARENT;
					}
				}
				LONG FLUIDSIM_VORTEXSUBD_SAMPLING 
				{
					CYCLE
					{
						FLUIDSIM_VORTEXSUBD_SAMPLING_LOW;
						FLUIDSIM_VORTEXSUBD_SAMPLING_HIGH;
					}
				}
				SEPARATOR {LINE;}
				LONG FLUIDSIM_VORTICITY_DEPENDENCY_L2
				{
					CYCLE
					{
						FLUIDSIM_VORTICITY_DEPENDENCY_OFF_L2;
						FLUIDSIM_VORTICITY_DEPENDENCY_MAGNITUDE_L2;
						FLUIDSIM_VORTICITY_DEPENDENCY_SMOKE_L2;
						FLUIDSIM_VORTICITY_DEPENDENCY_HEAT_L2;
						FLUIDSIM_VORTICITY_DEPENDENCY_VORTICITY_L2;
						FLUIDSIM_VORTICITY_DEPENDENCY_BDR_DISTANCE_L2;
					}
				}
				REAL FLUIDSIM_VORTICITY_DEPENDENCY_DENSITYLIMIT_L2 { MIN 0.0; MAX 100.0; UNIT PERCENT;}
				REAL FLUIDSIM_VORTICITY_DEPENDENCY_VORTICITYLIMIT_L2 { MIN 0.0; UNIT METER;}
				REAL FLUIDSIM_VORTICITY_DEPENDENCY_DISTANCELIMIT_L2 { MIN 0.0; MAX 10.0;}
				SEPARATOR {LINE;}
				REAL FLUIDSIM_VORTICITYHRES_L2 { MIN 0.0; MAX 1000000.0; STEP 0.01;}
				REAL FLUIDSIM_VORTICITY_RADIUS_L2 {MIN 1;}
				REAL FLUIDSIM_STRETCHLENGTH_L2 { MIN 0.001; MAX 2000000.0; STEP 0.001;}
				BOOL FLUIDSIM_VORTICITYPARTICLES_IPOLEMISSION_L2 {HIDDEN;}
				LONG FLUIDSIM_VORTKERNEL_L2
				{
					CYCLE
					{
						FLUIDSIM_VORTKERNEL_L2_STANDARD;
						FLUIDSIM_VORTKERNEL_L2_GAUSSAIN;
						FLUIDSIM_VORTKERNEL_L2_POLY;
						FLUIDSIM_VORTKERNEL_L2_SPIKE;
						FLUIDSIM_VORTKERNEL_L2_SMOOTH;
						FLUIDSIM_VORTKERNEL_L2_CUSTOM;
					}
				}
				REAL FLUIDSIM_VORTKERNEL_LENGTH_L2 { MIN 0.001; }
				SPLINE FLUIDSIM_CUSTOMKERNEL_L2
				{
					SHOWGRID_H; 
														  
					X_MIN 0; 
					X_MAX 1; 
										  
					Y_MIN 0; 
					Y_MAX 1; 
										  
					X_STEPS 0.01; 
					Y_STEPS 0.01; 
				}			
			}
			GROUP FlUIDSIM_SUBDIVISION_L3_SID
			{
				LONG FLUIDSIM_VORTEX_SUBGRIDLAYER_L3
				{
					CYCLE
					{	
						FLUIDSIM_VORTEX_SUBGRIDLAYER_L3_PARENT;
					}
				}
				LONG FLUIDSIM_VORTEXSUBD_SAMPLING_L3 
				{
					CYCLE
					{
						FLUIDSIM_VORTEXSUBD_SAMPLING_L3_LOW;
						FLUIDSIM_VORTEXSUBD_SAMPLING_L3_HIGH;
					}
				}
				SEPARATOR {LINE;}
				LONG FLUIDSIM_VORTICITY_DEPENDENCY_L3
				{
					CYCLE
					{
						FLUIDSIM_VORTICITY_DEPENDENCY_OFF_L3;
						FLUIDSIM_VORTICITY_DEPENDENCY_MAGNITUDE_L3;
						FLUIDSIM_VORTICITY_DEPENDENCY_SMOKE_L3;
						FLUIDSIM_VORTICITY_DEPENDENCY_HEAT_L3;
						FLUIDSIM_VORTICITY_DEPENDENCY_VORTICITY_L3;
						FLUIDSIM_VORTICITY_DEPENDENCY_BDR_DISTANCE_L3;
					}
				}
				REAL FLUIDSIM_VORTICITY_DEPENDENCY_DENSITYLIMIT_L3 { MIN 0.0; MAX 100.0; UNIT PERCENT;}
				REAL FLUIDSIM_VORTICITY_DEPENDENCY_VORTICITYLIMIT_L3 { MIN 0.0; UNIT METER;}
				REAL FLUIDSIM_VORTICITY_DEPENDENCY_DISTANCELIMIT_L3 { MIN 0.0; MAX 10.0;}
				SEPARATOR {LINE;}
				REAL FLUIDSIM_VORTICITYHRES_L3 { MIN 0.0; MAX 1000000.0; STEP 0.01;}
				REAL FLUIDSIM_VORTICITY_RADIUS_L3 {MIN 1;}
				REAL FLUIDSIM_STRETCHLENGTH_L3 { MIN 0.001; MAX 2000000.0; STEP 0.001;}
				BOOL FLUIDSIM_VORTICITYPARTICLES_IPOLEMISSION_L3 {HIDDEN;}
				LONG FLUIDSIM_VORTKERNEL_L3
				{
					CYCLE
					{
						FLUIDSIM_VORTKERNEL_L3_STANDARD;
						FLUIDSIM_VORTKERNEL_L3_GAUSSAIN;
						FLUIDSIM_VORTKERNEL_L3_POLY;
						FLUIDSIM_VORTKERNEL_L3_SPIKE;
						FLUIDSIM_VORTKERNEL_L3_SMOOTH;
						FLUIDSIM_VORTKERNEL_L3_CUSTOM;
					}
				}
				REAL FLUIDSIM_VORTKERNEL_LENGTH_L3 { MIN 0.001; }
				SPLINE FLUIDSIM_CUSTOMKERNEL_L3
				{
					SHOWGRID_H; 
														  
					X_MIN 0; 
					X_MAX 1; 
										  
					Y_MIN 0; 
					Y_MAX 1; 
										  
					X_STEPS 0.01; 
					Y_STEPS 0.01; 
				}			
			}
			GROUP FlUIDSIM_SUBDIVISION_L4_SID
			{			
				LONG FLUIDSIM_VORTEX_SUBGRIDLAYER_L4
				{
					CYCLE
					{	
						FLUIDSIM_VORTEX_SUBGRIDLAYER_L4_PARENT;
					}
				}
				LONG FLUIDSIM_VORTEXSUBD_SAMPLING_L4
				{
					CYCLE
					{
						FLUIDSIM_VORTEXSUBD_SAMPLING_L4_LOW;
						FLUIDSIM_VORTEXSUBD_SAMPLING_L4_HIGH;
					}
				}
				SEPARATOR {LINE;}
				LONG FLUIDSIM_VORTICITY_DEPENDENCY_L4
				{
					CYCLE
					{
						FLUIDSIM_VORTICITY_DEPENDENCY_OFF_L4;
						FLUIDSIM_VORTICITY_DEPENDENCY_MAGNITUDE_L4;
						FLUIDSIM_VORTICITY_DEPENDENCY_SMOKE_L4;
						FLUIDSIM_VORTICITY_DEPENDENCY_HEAT_L4;
						FLUIDSIM_VORTICITY_DEPENDENCY_VORTICITY_L4;
						FLUIDSIM_VORTICITY_DEPENDENCY_BDR_DISTANCE_L4;
					}
				}
				REAL FLUIDSIM_VORTICITY_DEPENDENCY_DENSITYLIMIT_L4 { MIN 0.0; MAX 100.0; UNIT PERCENT;}
				REAL FLUIDSIM_VORTICITY_DEPENDENCY_VORTICITYLIMIT_L4 { MIN 0.0; UNIT METER;}
				REAL FLUIDSIM_VORTICITY_DEPENDENCY_DISTANCELIMIT_L4 { MIN 0.0; MAX 10.0;}
				SEPARATOR {LINE;}
				REAL FLUIDSIM_VORTICITYHRES_L4 { MIN 0.0; MAX 1000000.0; STEP 0.01;}
				REAL FLUIDSIM_VORTICITY_RADIUS_L4 {MIN 1;}
				REAL FLUIDSIM_STRETCHLENGTH_L4 { MIN 0.001; MAX 2000000.0; STEP 0.001;}
				BOOL FLUIDSIM_VORTICITYPARTICLES_IPOLEMISSION_L4 {HIDDEN;}
				LONG FLUIDSIM_VORTKERNEL_L4
				{
					CYCLE
					{
						FLUIDSIM_VORTKERNEL_L4_STANDARD;
						FLUIDSIM_VORTKERNEL_L4_GAUSSAIN;
						FLUIDSIM_VORTKERNEL_L4_POLY;
						FLUIDSIM_VORTKERNEL_L4_SPIKE;
						FLUIDSIM_VORTKERNEL_L4_SMOOTH;
						FLUIDSIM_VORTKERNEL_L4_CUSTOM;
					}
				}
				REAL FLUIDSIM_VORTKERNEL_LENGTH_L4 { MIN 0.001; }
				SPLINE FLUIDSIM_CUSTOMKERNEL_L4
				{
					SHOWGRID_H; 
														  
					X_MIN 0; 
					X_MAX 1; 
										  
					Y_MIN 0; 
					Y_MAX 1; 
										  
					X_STEPS 0.01; 
					Y_STEPS 0.01; 
				}			
			}
		}
		GROUP FLUIDSIM_STARTGRID_SID
		{		
			DEFAULT 1;
			GROUP FLUIDSIM_FSSMIXER
			{
				IN_EXCLUDE FLUIDSIM_FSSMIXERLIST
				{
					NUM_FLAGS 6; 
					INIT_STATE 1;
					INIT_STATE 6;
					IMAGE_01_ON 1024293;
					IMAGE_01_OFF 1024294;
					IMAGE_02_ON 1024283;
					IMAGE_02_OFF 1024284;
					IMAGE_03_ON 1024285;
					IMAGE_03_OFF 1024286;
					IMAGE_04_ON 1024287;
					IMAGE_04_OFF 1024288;
					IMAGE_05_ON 1024289;
					IMAGE_05_OFF 1024290;
					IMAGE_06_ON 1024291;
					IMAGE_06_OFF 1024292;
					ACCEPT {  fx_fluidsim; };
				}			
			}
		}
	}
	GROUP ID_MEDIA_G
	{
		GROUP
		{
			COLUMNS 4;
			LONG FLUIDSIM_CHANNEL_SMOKE {ANIM OFF; CUSTOMGUI VISIBILITY;}
			LONG FLUIDSIM_CHANNEL_HEAT {ANIM OFF; CUSTOMGUI VISIBILITY;}
			LONG FLUIDSIM_CHANNEL_FIRE {ANIM OFF; CUSTOMGUI VISIBILITY; }
			LONG FLUIDSIM_CHANNEL_FUEL {ANIM OFF; CUSTOMGUI VISIBILITY; }
			LONG FLUIDSIM_CHANNEL_COLOR {ANIM OFF; CUSTOMGUI VISIBILITY; }
			LONG FLUIDSIM_CHANNEL_TEX {ANIM OFF; CUSTOMGUI VISIBILITY; }
			LONG FLUIDSIM_CHANNEL_MEMORY {ANIM OFF; CUSTOMGUI VISIBILITY; }
		}
		SEPARATOR { LINE; }
							
		GROUP ID_DENSITY_G
		{		
			DEFAULT 1;
			GROUP ID_SMOKECACHE_SID
			{	
				LONG   FLUIDSIM_SMOKECACHE_MODE 
				{
					CYCLE
					{
						FLUIDSIM_SMOKECACHE_MODE_OFF;
						FLUIDSIM_SMOKECACHE_MODE_FILE;
						//FLUIDSIM_SMOKECACHE_MODE_RAM;
					}
				}
				BUTTON FLUIDSIM_SMOKECACHE_SELECTFOLDER {}
				STRING FLUIDSIM_SMOKECACHE_FILENAME {ANIM OFF;}
				STRING FLUIDSIM_SMOKECACHE_FILENAME_NAME {ANIM OFF;}
				BOOL FLUIDSIM_SMOKECACHE_STARTFRAME {}
				GROUP
				{
					COLUMNS 2;
					LONG FLUIDSIM_SMOKECACHE_FRAME {MIN -1;}
					REAL FLUIDSIM_SMOKECACHE_BLEND {MIN 0; MAX 100; UNIT PERCENT; CUSTOMGUI REALSLIDER;}
				}
			}
			SEPARATOR {LINE;}
			REAL FLUIDSIM_MAXDENSITY {MIN 0.1;}	
			REAL FLUIDSIM_DIFFUSION { MIN 0.0; MAX 1000000.0; STEP 0.001;}
			REAL FLUIDSIM_DISSIPATION { MIN 0.0; MAX 100.0; STEP 0.001; CUSTOMGUI DOUBLE; DUNIT DUNIT_PSEC; DDIGITS 6; }	
			REAL FLUIDSIM_SMOKET {MIN 0; MAX 5000;}
			
			SEPARATOR {LINE;}

			BOOL FLUIDSIM_CONVECT_SMOKE {}
			BOOL FLUIDSIM_CLEAR_SMOKE {}
			LONG FLUIDSIM_TRANSPORTTYPE_SMOKE 
			{
				CYCLE
				{
				FLUIDSIM_TRANSPORTTYPE_SMOKE_1ST;
				FLUIDSIM_TRANSPORTTYPE_SMOKE_1ST_MASSMOMENTUM;
				FLUIDSIM_TRANSPORTTYPE_SMOKE_2ND;
				FLUIDSIM_TRANSPORTTYPE_SMOKE_2ND_MASSMOMENTUM;
				}
			}
			LONG FLUIDSIM_TRACEALGO_D
			{
				CYCLE
				{
				FLUIDSIM_TRACEALGO_D_EULER1ST;
				FLUIDSIM_TRACEALGO_D_RUNGA2ND;
				FLUIDSIM_TRACEALGO_D_RUNGA3RD;
				FLUIDSIM_TRACEALGO_D_RUNGA4TH;
				}
			}
			LONG FLUIDSIM_ALGO_DENSITY
			{
				CYCLE
				{
					FLUIDSIM_ALGO_D_LINEAR;
					FLUIDSIM_ALGO_D_COSINE;
					FLUIDSIM_ALGO_D_HERMITE;
				}
			}
			BOOL FLUIDSIM_SMOKETARGET {HIDDEN;}
			GROUP ID_SMOKETARGET_SID
			{
				BUTTON FLUIDSIM_SMOKETARGET_SET {}
				REAL FLUIDSIM_SMOKETARGET_ATTRACT {MIN 0.001; MAX 1000.0; STEP 0.001;}
				REAL FLUIDSIM_SMOKETARGET_ATTENUATE {MIN 0.0; MAX 1000.0; STEP 0.01;}

				REAL FLUIDSIM_SMOKETARGET_DIFFUSION { MIN 0.01; MAX 100.0; STEP 0.01;}
				LONG FLUIDSIM_SMOKETARGET_ITER { MIN 1; MAX 1000; }
			}
		}
		GROUP ID_TEMPERATURE
		{
			DEFAULT 1;
			GROUP ID_TEMPCACHE_SID
			{	
				LONG   FLUIDSIM_TEMPCACHE_MODE 
				{
					CYCLE
					{
						FLUIDSIM_TEMPCACHE_MODE_OFF;
						FLUIDSIM_TEMPCACHE_MODE_FILE;
						//FLUIDSIM_TEMPCACHE_MODE_RAM;
					}
				}
				BUTTON FLUIDSIM_TEMPCACHE_SELECTFOLDER {}
				STRING FLUIDSIM_TEMPCACHE_FILENAME {ANIM OFF;}
				STRING FLUIDSIM_TEMPCACHE_FILENAME_NAME {ANIM OFF;}
				BOOL FLUIDSIM_TEMPCACHE_STARTFRAME {}
				GROUP
				{
					COLUMNS 2;
					LONG FLUIDSIM_TEMPCACHE_FRAME {MIN -1;}
					REAL FLUIDSIM_TEMPCACHE_BLEND {MIN 0; MAX 100; UNIT PERCENT; CUSTOMGUI REALSLIDER;}
				}
			}			
			SEPARATOR {LINE;}
			REAL FLUIDSIM_MAXTEMPERATURE {MIN 1; CUSTOMGUI DOUBLE; DUNIT DUNIT_KELVIN; DDIGITS 1; STEP 1.0;}
			REAL FLUDISIM_TEMPERATURE_DIFFUSION {MIN 0; MAX 1000000.0; STEP 0.001;}
			REAL FLUIDSIM_AMBIENT {MIN 0; MAX 20000; CUSTOMGUI DOUBLE; DUNIT DUNIT_KELVIN; DDIGITS 1; STEP 1.0; }
			REAL FLUIDSIM_COOLING {MIN 0; MAX 100; UNIT PERCENT; }
					
			SEPARATOR{LINE;}
			BOOL FLUIDSIM_CONVECT_HEAT {}
			BOOL FLUIDSIM_CLEAR_HEAT {}
			
			LONG FLUIDSIM_TRANSPORTTYPE_TEMPERATURE 
			{
				CYCLE
				{
				FLUIDSIM_TRANSPORTTYPE_TEMPERATURE_1ST;
				FLUIDSIM_TRANSPORTTYPE_TEMPERATURE_2ND;
				}
			}
			LONG FLUIDSIM_TRACEALGO_T
			{
				CYCLE
				{
				FLUIDSIM_TRACEALGO_T_EULER1ST;
				FLUIDSIM_TRACEALGO_T_RUNGA2ND;
				FLUIDSIM_TRACEALGO_T_RUNGA3RD;
				FLUIDSIM_TRACEALGO_T_RUNGA4TH;
				}
			}
			LONG FLUIDSIM_ALGO_TEMPERATURE
			{
				CYCLE
				{
					FLUIDSIM_ALGO_T_LINEAR;
					FLUIDSIM_ALGO_T_COSINE;
					FLUIDSIM_ALGO_T_HERMITE;
				}
			}
		}	
		GROUP ID_FIRE_G
		{		
			DEFAULT 1;
			GROUP ID_FIRECACHE_SID
			{	
				LONG   FLUIDSIM_FIRECACHE_MODE 
				{
					CYCLE
					{
						FLUIDSIM_FIRECACHE_MODE_OFF;
						FLUIDSIM_FIRECACHE_MODE_FILE;
						//FLUIDSIM_FIRECACHE_MODE_RAM;
					}
				}
				BUTTON FLUIDSIM_FIRECACHE_SELECTFOLDER {}
				STRING FLUIDSIM_FIRECACHE_FILENAME {ANIM OFF;}
				STRING FLUIDSIM_FIRECACHE_FILENAME_NAME {ANIM OFF;}
				BOOL FLUIDSIM_FIRECACHE_STARTFRAME {}
				GROUP
				{
					COLUMNS 2;
					LONG FLUIDSIM_FIRECACHE_FRAME {MIN -1;}
					REAL FLUIDSIM_FIRECACHE_BLEND {MIN 0; MAX 100; UNIT PERCENT; CUSTOMGUI REALSLIDER;}
				}
			}
			
			SEPARATOR {LINE;}
			REAL FLUIDSIM_IGNITION_TEMP	{MIN 1; MAX 5000; CUSTOMGUI DOUBLE; DUNIT DUNIT_KELVIN; DDIGITS 1; STEP 1.0;}
			REAL FLUIDSIM_COOLINGPOINT	{MIN 0.1; MAX 1.0f; STEP 0.01;}
			REAL FLUIDSIM_HEATEXP		{MIN 0.001; MAX 100; STEP 0.001;}
			SPLINE FLUIDSIM_HEATUPCURVE
			{
				SHOWGRID_H; 
													  
				X_MIN 0; 
				X_MAX 1; 
									  
				Y_MIN 0; 
				Y_MAX 1; 
									  
				X_STEPS 0.01; 
				Y_STEPS 0.01; 
			}
						
			SEPARATOR FLUIDSIM_COMBUSTION_SEP {LINE;}
			LONG FLUIDSIM_COMBUSTION_TYPE
			{
				CYCLE
				{
					FLUIDSIM_COMBUSTION_TYPE_FUEL;
					FLUIDSIM_COMBUSTION_TYPE_FUEL_OXYGEN;
				}
			}
				
			BOOL FLUIDSIM_FUELPERFRAME	{}
			REAL FLUIDSIM_BURNINGRATE	{MIN 0.001; MAX 100.0; STEP 0.001; CUSTOMGUI DOUBLE; DUNIT DUNIT_PSEC; }
			REAL FLUIDSIM_OUTPUTHEAT	{MIN 0; MAX 5000; CUSTOMGUI DOUBLE; DUNIT DUNIT_KELVIN; DDIGITS 1; STEP 1.0;}
			REAL FLUIDSIM_COMBUSTION_PRESS	{MIN 0; STEP 0.01;}
			REAL FLUIDSIM_COMBUSTIONDENSITY {MIN 0; MAX 100; STEP 0.1; CUSTOMGUI DOUBLE; DUNIT DUNIT_PSEC; }
			REAL FLUIDSIM_OXYGEN		{MIN 0.001; STEP 0.01; }
			REAL FLUIDSIM_FIRESOOT		{MIN 0.0; MAX 1.0; STEP 0.01; CUSTOMGUI DOUBLE; DUNIT DUNIT_PSEC; }
			SPLINE FLUIDSIM_FIRESOOTCURVE
			{
				SHOWGRID_H; 
													  
				X_MIN 0; 
				X_MAX 1; 
									  
				Y_MIN 0; 
				Y_MAX 1; 
									  
				X_STEPS 0.01; 
				Y_STEPS 0.01; 
			}

			
			SEPARATOR {LINE;}
			
			LONG FLUIDSIM_FIRE_SCENELIGHTS
			{
				CYCLE
				{
					FLUIDSIM_FIRE_SCENELIGHTS_OFF;
					FLUIDSIM_FIRE_SCENELIGHTS_ON;
					FLUIDSIM_FIRE_SCENELIGHTS_RENDER;
				}
			}
			LONG FLUIDSIM_FIRE_SCENELIGHTS_LIFETIME {MIN 4; }
			LONG FLUIDSIM_FIRE_SCENELIGHTS_TIMING { MIN 1; MAX 10; }
			LONG FLUIDSIM_FIRE_SCENELIGHTS_RATE { MIN 1; MAX 10; }
			REAL FLUIDSIM_FIRE_SCENELIGHTS_INTENSTIY { MIN 0; MAX 1000; UNIT PERCENT; }
			REAL FLUIDSIM_FIRE_SCENELIGHTS_RADIUS { MIN 0; }
			LONG FLUIDSIM_FIRE_SCENELIGHTS_SHADOW 
			{ 
				CYCLE 
				{ 
				FLUIDSIM_FIRE_SCENELIGHTS_SHADOW_NONE;
				FLUIDSIM_FIRE_SCENELIGHTS_SHADOW_SOFT; 
				FLUIDSIM_FIRE_SCENELIGHTS_SHADOW_HARD;
				FLUIDSIM_FIRE_SCENELIGHTS_SHADOW_AREA;
				}
			}
			REAL FLUIDSIM_FIRE_SCENELIGHTS_SHADOWDENSITY {MIN 0; MAX 100; UNIT PERCENT;}
			LONG FLUIDSIM_FIRE_SCENELIGHTS_COLORING
			{
				CYCLE
				{
					FLUIDSIM_FIRE_SCENELIGHTS_COLORING_PHYSICAL;
					//FLUIDSIM_FIRE_SCENELIGHTS_COLORING_SHADER;
				}
			}
			LINK FLUIDSIM_FIRE_SCENELIGHTS_COLORING_SHADERLINK {ACCEPT{fx_fluidsmoke;}; HIDDEN;}

			SEPARATOR {LINE;}

			BOOL FLUIDSIM_CONVECT_FIRE {}
			BOOL FLUIDSIM_CLEAR_FIRE {}
			LONG FLUIDSIM_TRANSPORTTYPE_FIRE 
			{
				CYCLE
				{
				FLUIDSIM_TRANSPORTTYPE_FIRE_1ST;
				FLUIDSIM_TRANSPORTTYPE_FIRE_2ND;
				}
			}
			LONG FLUIDSIM_TRACEALGO_FIRE
			{
				CYCLE
				{
				FLUIDSIM_TRACEALGO_FIRE_EULER1ST;
				FLUIDSIM_TRACEALGO_FIRE_RUNGA2ND;
				FLUIDSIM_TRACEALGO_FIRE_RUNGA3RD;
				FLUIDSIM_TRACEALGO_FIRE_RUNGA4TH;
				}
			}
			LONG FLUIDSIM_ALGO_FIRE
			{
				CYCLE
				{
					FLUIDSIM_ALGO_FIRE_LINEAR;
					FLUIDSIM_ALGO_FIRE_COSINE;
					FLUIDSIM_ALGO_FIRE_HERMITE;
				}
			}
		}
		GROUP ID_FUEL_G
		{
			DEFAULT 1;
			GROUP ID_FUELCACHE_SID
			{	
				LONG   FLUIDSIM_FUELCACHE_MODE 
				{
					CYCLE
					{
						FLUIDSIM_FUELCACHE_MODE_OFF;
						FLUIDSIM_FUELCACHE_MODE_FILE;
						//FLUIDSIM_FUELCACHE_MODE_RAM;
					}
				}
				BUTTON FLUIDSIM_FUELCACHE_SELECTFOLDER {}
				STRING FLUIDSIM_FUELCACHE_FILENAME {ANIM OFF;}
				STRING FLUIDSIM_FUELCACHE_FILENAME_NAME {ANIM OFF;}
				BOOL FLUIDSIM_FUELCACHE_STARTFRAME {}
				GROUP
				{
					COLUMNS 2;
					LONG FLUIDSIM_FUELCACHE_FRAME {MIN -1;}
					REAL FLUIDSIM_FUELCACHE_BLEND {MIN 0; MAX 100; UNIT PERCENT; CUSTOMGUI REALSLIDER;}
				}
			}
			
			SEPARATOR {LINE;}
			REAL FLUIDSIM_FUELDIFFUSION	{MIN 0; MAX 1000000; STEP 0.001;}
			REAL FLUIDSIM_FUELDISSIPATION	{MIN 0; MAX 10; STEP 0.001; CUSTOMGUI DOUBLE; DUNIT DUNIT_PSEC; DDIGITS 5;}
			SEPARATOR {LINE;}

			BOOL FLUIDSIM_CONVECT_FUEL	{}
			BOOL FLUIDSIM_CLEAR_FUEL {}
			LONG FLUIDSIM_TRANSPORTTYPE_FUEL 
			{
				CYCLE
				{
				FLUIDSIM_TRANSPORTTYPE_FUEL_1ST;
				FLUIDSIM_TRANSPORTTYPE_FUEL_2ND;
				}
			}
			LONG FLUIDSIM_TRACEALGO_F
			{
				CYCLE
				{
				FLUIDSIM_TRACEALGO_F_EULER1ST;
				FLUIDSIM_TRACEALGO_F_RUNGA2ND;
				FLUIDSIM_TRACEALGO_F_RUNGA3RD;
				FLUIDSIM_TRACEALGO_F_RUNGA4TH;
				}
			}
			LONG FLUIDSIM_ALGO_FUEL
			{
				CYCLE
				{
					FLUIDSIM_ALGO_F_LINEAR;
					FLUIDSIM_ALGO_F_COSINE;
					FLUIDSIM_ALGO_F_HERMITE;
				}
			}
		}	
		GROUP ID_COLOR_G
		{
			DEFAULT 1;
			GROUP ID_COLORCACHE_SID
			{	
				LONG   FLUIDSIM_COLORCACHE_MODE 
				{
					CYCLE
					{
						FLUIDSIM_COLORCACHE_MODE_OFF;
						FLUIDSIM_COLORCACHE_MODE_FILE;
						//FLUIDSIM_COLORCACHE_MODE_RAM;
					}
				}
				BUTTON FLUIDSIM_COLORCACHE_SELECTFOLDER {}
				STRING FLUIDSIM_COLORCACHE_FILENAME {ANIM OFF;}
				STRING FLUIDSIM_COLORCACHE_FILENAME_NAME {ANIM OFF;}
				BOOL FLUIDSIM_COLORCACHE_STARTFRAME {}
				GROUP
				{
					COLUMNS 2;
					LONG FLUIDSIM_COLORCACHE_FRAME {MIN -1;}
					REAL FLUIDSIM_COLORCACHE_BLEND {MIN 0; MAX 100; UNIT PERCENT; CUSTOMGUI REALSLIDER;}
				}
			}
			
			SEPARATOR {LINE;}
			REAL FLUIDSIM_DISSIPATION_COLOR { MIN 0.0; MAX 100.0; STEP 0.001; CUSTOMGUI DOUBLE; DUNIT DUNIT_PSEC;}	
			SEPARATOR {LINE;}
			BOOL FLUIDSIM_CONVECT_COLOR {}
			BOOL FLUIDSIM_CLEAR_COLOR {}
			LONG FLUIDSIM_TRANSPORTTYPE_COLOR 
			{
				CYCLE
				{
				FLUIDSIM_TRANSPORTTYPE_COLOR_1ST;
				FLUIDSIM_TRANSPORTTYPE_COLOR_2ND;
				}
			}
			LONG FLUIDSIM_TRACEALGO_COLOR
			{
				CYCLE
				{
				FLUIDSIM_TRACEALGO_COLOR_EULER1ST;
				FLUIDSIM_TRACEALGO_COLOR_RUNGA2ND;
				FLUIDSIM_TRACEALGO_COLOR_RUNGA3RD;
				FLUIDSIM_TRACEALGO_COLOR_RUNGA4TH;
				}
			}
			LONG FLUIDSIM_ALGO_COLOR
			{
				CYCLE
				{
					FLUIDSIM_ALGO_COLOR_LINEAR;
					FLUIDSIM_ALGO_COLOR_COSINE;
					FLUIDSIM_ALGO_COLOR_HERMITE;
				}
			}
		}
		GROUP ID_FLOW_G
		{	
			DEFAULT 1;
			GROUP ID_FLOWMAPCACHE_SID
			{	
				LONG   FLUIDSIM_FLOWMAPCACHE_MODE 
				{
					CYCLE
					{
						FLUIDSIM_FLOWMAPCACHE_MODE_OFF;
						FLUIDSIM_FLOWMAPCACHE_MODE_FILE;
						//FLUIDSIM_FLOWMAPCACHE_MODE_RAM;
					}
				}
				BUTTON FLUIDSIM_FLOWMAPCACHE_SELECTFOLDER {}
				STRING FLUIDSIM_FLOWMAPCACHE_FILENAME {ANIM OFF;}
				STRING FLUIDSIM_FLOWMAPCACHE_FILENAME_NAME {ANIM OFF;}
				BOOL FLUIDSIM_FLOWMAPCACHE_STARTFRAME {}
				GROUP
				{
					COLUMNS 2;
					LONG FLUIDSIM_FLOWMAPCACHE_FRAME {MIN -1;}
					REAL FLUIDSIM_FLOWMAPCACHE_BLEND {MIN 0; MAX 100; UNIT PERCENT; CUSTOMGUI REALSLIDER;}
				}
			}
			
			SEPARATOR {LINE;}
			BOOL FLUIDSIM_CONVECT_TEX {}
			BOOL FLUIDSIM_CLEAR_TEX {}
			LONG FLUIDSIM_TRANSPORTTYPE_TEX 
			{
				CYCLE
				{
				FLUIDSIM_TRANSPORTTYPE_TEX_1ST;
				FLUIDSIM_TRANSPORTTYPE_TEX_2ND;
				}
			}
			LONG FLUIDSIM_TRACEALGO_TEX
			{
				CYCLE
				{
				FLUIDSIM_TRACEALGO_TEX_EULER1ST;
				FLUIDSIM_TRACEALGO_TEX_RUNGA2ND;
				FLUIDSIM_TRACEALGO_TEX_RUNGA3RD;
				FLUIDSIM_TRACEALGO_TEX_RUNGA4TH;
				}
			}
			LONG FLUIDSIM_ALGO_TEX
			{
				CYCLE
				{
					FLUIDSIM_ALGO_TEX_LINEAR;
					FLUIDSIM_ALGO_TEX_COSINE;
					FLUIDSIM_ALGO_TEX_HERMITE;
				}
			}
		}
		GROUP FlUIDSIM_GMEMORY_G
		{
			DEFAULT 1;
			LONG FlUIDSIM_GMEMORY_FIELD
			{
				CYCLE
				{
					FlUIDSIM_GMEMORY_FIELD_SMOKE;
					FlUIDSIM_GMEMORY_FIELD_HEAT;
					FlUIDSIM_GMEMORY_FIELD_FUEL;				
					FlUIDSIM_GMEMORY_FIELD_FIRE; 
				}
			}
			LONG FLUIDSIM_GMEMORY_FIELDLIQUID
			{
				CYCLE
				{
					FLUIDSIM_GMEMORY_FIELDLIQUID_WATER;
					FLUIDSIM_GMEMORY_FIELDLIQUID_VISCOSITY;
					//FLUIDSIM_GMEMORY_FIELDLIQUID_HEAT;
				}
			}
			REAL FlUIDSIM_GMEMORY_STORE {MIN 0; MAX 100; UNIT PERCENT;}
			REAL FlUIDSIM_GMEMORY_DISSIPATE {MIN 0; MAX 100; UNIT PERCENT;}
		}
	}	
	GROUP ID_PARTICLES_G
	{
		GROUP
		{
			COLUMNS 3;
			LONG FLUIDSIM_CHANNEL_FLUIDPARTICLES {ANIM OFF; CUSTOMGUI VISIBILITY; BOOLEAN;}
			LONG FLUIDSIM_CHANNEL_SIMPLEPARTICLES {ANIM OFF; CUSTOMGUI VISIBILITY;}
			LONG FLUIDSIM_CHANNEL_THINKINGPARTICLES {ANIM OFF; CUSTOMGUI VISIBILITY;}
			
			LONG FLUIDSIM_CHANNEL_FOAMPARTICLES {ANIM OFF; CUSTOMGUI VISIBILITY;}	
			LONG FLUIDSIM_CHANNEL_BUBBLEPARTICLES {ANIM OFF; CUSTOMGUI VISIBILITY; HIDDEN;}
			LONG FLUIDSIM_CHANNEL_SPRAYPARTICLES {ANIM OFF; CUSTOMGUI VISIBILITY; HIDDEN;}	
		}
		SEPARATOR {LINE;}

		BUTTON FLUIDSIM_ADDGROUPOBJECT {}
		IN_EXCLUDE FLUIDSIM_GROUPLIST
		{
			NUM_FLAGS 0; INIT_STATE 0; SEND_SELCHNGMSG 1;
			ACCEPT {  fx_fluidgroup; };
		}

		SEPARATOR {}

		GROUP ID_FLUIDPARTICLES_G
		{			
			GROUP ID_FPCACHE_SID
			{	
				LONG   FLUIDSIM_FPCACHE_MODE 
				{
					CYCLE
					{
						FLUIDSIM_FPCACHE_MODE_OFF;
						FLUIDSIM_FPCACHE_MODE_FILE;
					}
				}
				BUTTON FLUIDSIM_FPCACHE_SELECTFOLDER {}
				STRING FLUIDSIM_FPCACHE_FILENAME {ANIM OFF;}
				STRING FLUIDSIM_FPCACHE_FILENAME_NAME {ANIM OFF;}
				GROUP
				{
					COLUMNS 2;
					BOOL FLUIDSIM_FPCACHE_STARTFRAME {}
					LONG FLUIDSIM_FPCACHE_FRAME {MIN -1;}
				}
			}
			SEPARATOR {LINE;}
			LONG FLUIDSIM_TRACEALGO_FP
			{
				CYCLE
				{
				FLUIDSIM_TRACEALGO_FP_EULER1ST;
				FLUIDSIM_TRACEALGO_FP_RUNGA2ND;
				FLUIDSIM_TRACEALGO_FP_RUNGA3RD;
				FLUIDSIM_TRACEALGO_FP_RUNGA4TH;
				}
			}
			LONG FLUIDSIM_SUBSTEPS_FP {MIN 0; MAX 1000;}
			BOOL FLUIDSIM_FLUIDPARTICLES_CHECKADVECT {}

			GROUP ID_FLUIDPARTICLES_SID_MEDIA
			{
				DEFAULT 1;
				BOOL	FLUIDSIM_FLUIDPARTICLES_CONSTANTDENSITY {}
				BOOL	FLUIDSIM_FLUIDPARTICLES_EMITWATER {}
				BOOL	FLUIDSIM_FLUIDPARTICLES_EMITWATER_SAMELOCATION {}

				LONG	FLUIDSIM_FLUIDPARTICLES_MEDIARADFALLOFF
				{
					CYCLE
					{
						FLUIDSIM_FLUIDPARTICLES_MEDIARADFALLOFF_NONE;
						FLUIDSIM_FLUIDPARTICLES_MEDIARADFALLOFF_LINEAR;
						//FLUIDSIM_FLUIDPARTICLES_MEDIARADFALLOFF_CUBIC;
						FLUIDSIM_FLUIDPARTICLES_MEDIARADFALLOFF_CUSTOM;
					}
				}
				GRADIENT FLUIDSIM_FLUIDPARTICLES_MEDIARADFALLOFF_GRAD {ALPHA; ANIM ON;}
				BOOL	FLUIDSIM_FLUIDPARTICLES_DENSITY_USEAGE {}
				GRADIENT FLUIDSIM_FLUIDPARTICLES_DENSITY_AGE {ALPHA; ANIM ON;}	
			}		
			GROUP ID_FLUIDPARTICLES_SID_WIND
			{
				DEFAULT 1;
				BOOL	FLUIDSIM_FLUIDPARTICLES_CONSTANTVELOCITY {}
				LONG	FLUIDSIM_FLUIDPARTICLES_WINDDIR
				{
					CYCLE
					{
						FLUIDSIM_FLUIDPARTICLES_WINDDIR_X;
						FLUIDSIM_FLUIDPARTICLES_WINDDIR_Y;
						FLUIDSIM_FLUIDPARTICLES_WINDDIR_Z;
						FLUIDSIM_FLUIDPARTICLES_WINDDIR_VELOCITY;
					}
				}
				REAL	FLUIDSIM_FLUIDPARTICLES_IMPACTVELOCITY {MIN 0; UNIT PERCENT;}
				REAL	FLUIDSIM_FLUIDPARTICLES_MASSINFLUENCE {MIN 0; UNIT PERCENT;}
				REAL	FLUIDSIM_FLUIDPARTICLES_SIZEINFLUENCE {MIN 0; UNIT PERCENT;}
				
				LONG	FLUIDSIM_FLUIDPARTICLES_RADFALLOFF
				{
					CYCLE
					{
						FLUIDSIM_FLUIDPARTICLES_RADFALLOFF_NONE;
						FLUIDSIM_FLUIDPARTICLES_RADFALLOFF_LINEAR;
						//FLUIDSIM_FLUIDPARTICLES_RADFALLOFF_CUBIC;
						FLUIDSIM_FLUIDPARTICLES_RADFALLOFF_CUSTOM;
					}
				}
				GRADIENT FLUIDSIM_FLUIDPARTICLES_RADFALLOFF_GRAD {ALPHA; ANIM ON;}
			}
			GROUP ID_FLUIDPARTICLES_SID_SP
			{
				BOOL	FLUIDSIM_CREATE_SIMPLEPARTICLES_OUTSIDE {}
				REAL	FLUIDSIM_SIMPLEPARTICLES_OUTGOING_VELOCITY {UNIT PERCENT;}
			}		
			GROUP FLUIDSIM_S_VORTEXEMISSION
			{
				LONG FLUIDSIM_VORTEX_SUBGRIDLAYER 
				{
					CYCLE
					{	
						FLUIDSIM_VORTEX_SUBGRIDLAYER_PARENT;
					}
				}
				LONG FLUIDSIM_VORTEX_ALIGN
				{
					CYCLE
					{
						FLUIDSIM_VORTEX_ALIGN_X;
						FLUIDSIM_VORTEX_ALIGN_Y;
						FLUIDSIM_VORTEX_ALIGN_Z;
						FLUIDSIM_VORTEX_ALIGN_SPHERICAL;
						FLUIDSIM_VORTEX_ALIGN_BOX;
						FLUIDSIM_VORTEX_ALIGN_CYLINDRICAL;
						FLUIDSIM_VORTEX_ALIGN_RANDOM;
						FLUIDSIM_VORTEX_ALIGN_XYZ;
					}
				}
				BOOL FLUIDSIM_VORTEX_ALIGN_INVERT {}
				VECTOR FLUIDSIM_VORTEX_XYZ {MIN -1 -1 -1; MAX 1 1 1; STEP 0.001;}

				SEPARATOR {LINE;}
				GROUP
				{
					COLUMNS 2;
					LONG FLUIDSIM_VORTEX_SAMPLES {MIN 0;}
					REAL FLUIDSIM_VORTEX_SAMPLESVAR {MIN 0; MAX 100; UNIT PERCENT;}

					LONG FLUIDSIM_VORTEX_AGE {MIN 1;}
					REAL FLUIDSIM_VORTEX_AGEVAR {MIN 0; MAX 100; UNIT PERCENT;}

					REAL FLUIDSIM_VORTEX_RADIUS { MIN 0.0; MAX 5000.0; STEP 0.01; UNIT METER;}	
					REAL FLUIDSIM_VORTEX_RADIUSVAR {MIN 0.0; MAX 100.0; UNIT PERCENT;}
				}
			}
			
		}
		GROUP ID_SIMPLEPARTICLES_G
		{
			BOOL	FLUIDSIM_SIMPLEPARTICLES_USE {HIDDEN;}		
			LINK	FLUIDSIM_SIMPLEPARTICLES_EMITTER {ACCEPT{fx_particle;};}
			BOOL	FLUIDSIM_SIMPLEPARTICLES_ATTACHOBJECTS {HIDDEN;}
				
			GROUP ID_SIMPLEPARTICLES_S_EMISSION
			{
				DEFAULT 1;
				BOOL	FLUIDSIM_SIMPLEPARTICLES_EMITWATER {}		
				GROUP
				{
					COLUMNS 2;
					//REAL	FLUIDSIM_SIMPLEPARTICLES_RAD {MIN 0.0; STEP 0.1;}

					REAL	FLUIDSIM_SIMPLEPARTICLES_DENSITY {MIN 0; STEP 0.001;}
					REAL	FLUIDSIM_SIMPLEPARTICLES_HEAT {MIN 0; MAX 5000;}
					REAL	FLUIDSIM_SIMPLEPARTICLES_FUEL  {MIN 0; MAX 1.0; STEP 0.01;}
					REAL	FLUIDSIM_SIMPLEPARTICLES_PRESSURE {MIN 0; MAX 10000;STEP 0.001;}
					COLOR	FLUIDSIM_SIMPLEPARTICLES_COLOR {}		
					REAL	FLUIDSIM_SIMPLEPARTICLES_RAD_VAR {MIN 0.0; MAX 100; UNIT PERCENT;}
				}
				
				LONG	FLUIDSIM_SIMPLEPARTICLES_MEDIARADFALLOFF
				{
					CYCLE
					{
						FLUIDSIM_SIMPLEPARTICLES_MEDIARADFALLOFF_NONE;
						FLUIDSIM_SIMPLEPARTICLES_MEDIARADFALLOFF_LINEAR;
						//FLUIDSIM_SIMPLEPARTICLES_MEDIARADFALLOFF_CUBIC;
						FLUIDSIM_SIMPLEPARTICLES_MEDIARADFALLOFF_CUSTOM;
					}
				}
				GRADIENT FLUIDSIM_SIMPLEPARTICLES_MEDIARADFALLOFF_GRAD {ALPHA; ANIM ON;}
				
				BOOL	FLUIDSIM_SIMPLEPARTICLES_MEDIA_USEAGE {}
				GRADIENT FLUIDSIM_SIMPLEPARTICLES_MEDIA_AGE {ALPHA; ANIM ON;}	
			}
			GROUP ID_SIMPLEPARTICLES_S_EMISSIONWIND
			{
				DEFAULT 1;
				LONG	FLUIDSIM_SIMPLEPARTICLES_WINDDIR
				{
					CYCLE
					{
						FLUIDSIM_SIMPLEPARTICLES_WINDDIR_X;
						FLUIDSIM_SIMPLEPARTICLES_WINDDIR_Y;
						FLUIDSIM_SIMPLEPARTICLES_WINDDIR_Z;
						FLUIDSIM_SIMPLEPARTICLES_WINDDIR_VELOCITY;
					}
				}
				REAL	FLUIDSIM_SIMPLEPARTICLES_IMPACTVELOCITY {UNIT PERCENT;}
				REAL	FLUIDSIM_SIMPLEPARTICLES_MASSINFLUENCE {MIN 0; UNIT PERCENT;}
				REAL	FLUIDSIM_SIMPLEPARTICLES_SIZEINFLUENCE {MIN 0; UNIT PERCENT;}

				LONG	FLUIDSIM_SIMPLEPARTICLES_RADFALLOFF
				{
					CYCLE
					{
						FLUIDSIM_SIMPLEPARTICLES_RADFALLOFF_NONE;
						FLUIDSIM_SIMPLEPARTICLES_RADFALLOFF_LINEAR;
						//FLUIDSIM_SIMPLEPARTICLES_RADFALLOFF_CUBIC;
						FLUIDSIM_SIMPLEPARTICLES_RADFALLOFF_CUSTOM;
					}
				}
				GRADIENT FLUIDSIM_SIMPLEPARTICLES_RADFALLOFF_GRAD {ALPHA; ANIM ON;}

				BOOL	FLUIDSIM_SIMPLEPARTICLES_DENSITY_USEAGE {}
				GRADIENT FLUIDSIM_SIMPLEPARTICLES_AGEGRADIENT {ALPHA; ANIM ON;}
			}
			GROUP ID_SIMPLEPARTICLES_S_CONVERSIONTOFP
			{
				BOOL	FLUIDSIM_CREATE_FLUIDPARTICLES_INSIDE {}
				GROUP
				{
					COLUMNS 2;
					REAL	FLUIDSIM_SP_TO_FP_RAD {MIN 0.0; STEP 0.1;}
					REAL	FLUIDSIM_SP_TO_FP_RAD_VAR {MIN 0.0; MAX 100; UNIT PERCENT;}

					REAL	FLUIDSIM_SP_TO_FP_DENSITY {MIN 0; STEP 0.001;}
					REAL	FLUIDSIM_SP_TO_FP_HEAT {MIN 0; MAX 5000;}
					REAL	FLUIDSIM_SP_TO_FP_FUEL {MIN 0; STEP 0.001;}
					REAL	FLUIDSIM_SP_TO_FP_PRESSURE {MIN 0; MAX 10000;STEP 0.001;}
					COLOR	FLUIDSIM_SP_TO_FP_COLOR {}
				}
			}		
			GROUP FLUIDSIM_S_VORTEXEMISSIONSP
			{
				LONG FLUIDSIM_VORTEXSP_SUBGRIDLAYER 
				{
					CYCLE
					{	
						FLUIDSIM_VORTEXSP_SUBGRIDLAYER_PARENT;
					}
				}
				LONG FLUIDSIM_VORTEXSP_ALIGN
				{
					CYCLE
					{
						FLUIDSIM_VORTEXSP_ALIGN_X;
						FLUIDSIM_VORTEXSP_ALIGN_Y;
						FLUIDSIM_VORTEXSP_ALIGN_Z;
						FLUIDSIM_VORTEXSP_ALIGN_SPHERICAL;
						FLUIDSIM_VORTEXSP_ALIGN_BOX;
						FLUIDSIM_VORTEXSP_ALIGN_CYLINDRICAL;
						FLUIDSIM_VORTEXSP_ALIGN_RANDOM;
						FLUIDSIM_VORTEXSP_ALIGN_XYZ;
					}
				}
				BOOL FLUIDSIM_VORTEXSP_ALIGN_INVERT {}
				VECTOR FLUIDSIM_VORTEXSP_XYZ {MIN -1 -1 -1; MAX 1 1 1; STEP 0.001;}

				SEPARATOR {LINE;}
				GROUP
				{
					COLUMNS 2;
					LONG FLUIDSIM_VORTEXSP_SAMPLES {MIN 0;}
					REAL FLUIDSIM_VORTEXSP_SAMPLESVAR {MIN 0; MAX 100; UNIT PERCENT;}

					LONG FLUIDSIM_VORTEXSP_AGE {MIN 1;}
					REAL FLUIDSIM_VORTEXSP_AGEVAR {MIN 0; MAX 100; UNIT PERCENT;}

					REAL FLUIDSIM_VORTEXSP_RADIUS { MIN 0.0; MAX 5000.0; STEP 0.01; UNIT METER;}	
					REAL FLUIDSIM_VORTEXSP_RADIUSVAR {MIN 0.0; MAX 100.0; UNIT PERCENT;}
				}
			}
		}
		GROUP ID_THINKINGPARTICLES_G
		{
			BOOL	FLUIDSIM_THINKINGPARTICLES_USE {HIDDEN;}

			GROUP ID_THINKINGPARTICLES_S_EMISSION
			{			
				DEFAULT 1;
				BOOL	FLUIDSIM_THINKINGPARTICLES_EMITWATER {}	
				GROUP
				{
					COLUMNS 2;
					REAL	FLUIDSIM_THINKINGPARTICLES_DENSITY {MIN 0; STEP 0.001;}
					REAL	FLUIDSIM_THINKINGPARTICLES_HEAT {MIN 0; MAX 5000;}
					REAL	FLUIDSIM_THINKINGPARTICLES_FUEL  {MIN 0; MAX 1.0; STEP 0.01;}
					REAL	FLUIDSIM_THINKINGPARTICLES_PRESSURE {MIN 0; MAX 10000;STEP 0.001;}	
					COLOR	FLUIDSIM_THINKINGPARTICLES_COLOR {}
					REAL	FLUIDSIM_THINKINGPARTICLES_MEDIA_VAR {MIN 0.0; MAX 100; UNIT PERCENT;}
				}
				
				LONG	FLUIDSIM_THINKINGPARTICLES_MEDIARADFALLOFF
				{
					CYCLE
					{
						FLUIDSIM_THINKINGPARTICLES_MEDIARADFALLOFF_NONE;
						FLUIDSIM_THINKINGPARTICLES_MEDIARADFALLOFF_LINEAR;
						//FLUIDSIM_THINKINGPARTICLES_MEDIARADFALLOFF_CUBIC;
						FLUIDSIM_THINKINGPARTICLES_MEDIARADFALLOFF_CUSTOM;
					}
				}
				GRADIENT FLUIDSIM_THINKINGPARTICLES_MEDIARADFALLOFF_GRAD {ALPHA; ANIM ON;}
				BOOL	FLUIDSIM_THINKINGPARTICLES_DENSITY_USEAGE {}
				GRADIENT FLUIDSIM_THINKINGPARTICLES_AGEGRADIENT {ALPHA; ANIM ON;}
			}
			GROUP ID_THINKINGPARTICLES_S_EMISSIONWIND
			{			
				DEFAULT 1;
				LONG	FLUIDSIM_THINKINGPARTICLES_WINDDIR
				{
					CYCLE
					{
						FLUIDSIM_THINKINGPARTICLES_WINDDIR_X;
						FLUIDSIM_THINKINGPARTICLES_WINDDIR_Y;
						FLUIDSIM_THINKINGPARTICLES_WINDDIR_Z;
						FLUIDSIM_THINKINGPARTICLES_WINDDIR_VELOCITY;
						FLUIDSIM_THINKINGPARTICLES_WINDDIR_SPIN;
						FLUIDSIM_THINKINGPARTICLES_WINDDIR_ALIGNMENTX;
						FLUIDSIM_THINKINGPARTICLES_WINDDIR_ALIGNMENTY;					
						FLUIDSIM_THINKINGPARTICLES_WINDDIR_ALIGNMENTZ;
					}
				}			
				REAL	FLUIDSIM_THINKINGPARTICLES_IMPACTVELOCITY {UNIT PERCENT;}
				REAL	FLUIDSIM_THINKINGPARTICLES_MASSINFLUENCE {MIN 0; UNIT PERCENT;}
				REAL	FLUIDSIM_THINKINGPARTICLES_SIZEINFLUENCE {MIN 0; UNIT PERCENT;}

				LONG	FLUIDSIM_THINKINGPARTICLES_RADFALLOFF
				{
					CYCLE
					{
						FLUIDSIM_THINKINGPARTICLES_RADFALLOFF_NONE;
						FLUIDSIM_THINKINGPARTICLES_RADFALLOFF_LINEAR;
						//FLUIDSIM_THINKINGPARTICLES_RADFALLOFF_CUBIC;
						FLUIDSIM_THINKINGPARTICLES_RADFALLOFF_CUSTOM;
					}
				}
				GRADIENT FLUIDSIM_THINKINGPARTICLES_RADFALLOFF_GRAD {ALPHA; ANIM ON;}
				BOOL	FLUIDSIM_THINKINGPARTICLES_WIND_USEAGE {}
				GRADIENT FLUIDSIM_THINKINGPARTICLES_WIND_GRADIENT {ALPHA; ANIM ON;}
			}				
			GROUP FLUIDSIM_S_VORTEXEMISSIONTP
			{
				LONG FLUIDSIM_VORTEXTP_SUBGRIDLAYER 
				{
					CYCLE
					{	
						FLUIDSIM_VORTEXTP_SUBGRIDLAYER_PARENT;
					}
				}
				LONG FLUIDSIM_VORTEXTP_ALIGN
				{
					CYCLE
					{
						FLUIDSIM_VORTEXTP_ALIGN_X;
						FLUIDSIM_VORTEXTP_ALIGN_Y;
						FLUIDSIM_VORTEXTP_ALIGN_Z;
						FLUIDSIM_VORTEXTP_ALIGN_SPHERICAL;
						FLUIDSIM_VORTEXTP_ALIGN_BOX;
						FLUIDSIM_VORTEXTP_ALIGN_CYLINDRICAL;
						FLUIDSIM_VORTEXTP_ALIGN_RANDOM;
						FLUIDSIM_VORTEXTP_ALIGN_XYZ;
					}
				}
				BOOL FLUIDSIM_VORTEXTP_ALIGN_INVERT {}
				VECTOR FLUIDSIM_VORTEXTP_XYZ {MIN -1 -1 -1; MAX 1 1 1; STEP 0.001;}

				SEPARATOR {LINE;}
				GROUP
				{
					COLUMNS 2;
					LONG FLUIDSIM_VORTEXTP_SAMPLES {MIN 0;}
					REAL FLUIDSIM_VORTEXTP_SAMPLESVAR {MIN 0; MAX 100; UNIT PERCENT;}

					LONG FLUIDSIM_VORTEXTP_AGE {MIN 1;}
					REAL FLUIDSIM_VORTEXTP_AGEVAR {MIN 0; MAX 100; UNIT PERCENT;}

					REAL FLUIDSIM_VORTEXTP_RADIUS { MIN 0.0; MAX 5000.0; STEP 0.01; UNIT METER;}	
					REAL FLUIDSIM_VORTEXTP_RADIUSVAR {MIN 0.0; MAX 100.0; UNIT PERCENT;}
				}
			}
		}		
		GROUP ID_FOAMPARTICLES_G
		{			
			LONG FLUIDSIM_TRACEALGO_FOAM
			{
				CYCLE
				{
				FLUIDSIM_TRACEALGO_FOAM_EULER1ST;
				FLUIDSIM_TRACEALGO_FOAM_RUNGA2ND;
				FLUIDSIM_TRACEALGO_FOAM_RUNGA3RD;
				FLUIDSIM_TRACEALGO_FOAM_RUNGA4TH;
				}
			}
			LONG FLUIDSIM_SUBSTEPS_FOAM {MIN 0; MAX 1000;}
			BOOL FLUIDSIM_FOAMPARTICLES_CHECKADVECT {}
		}
		GROUP ID_BUBBLEPARTICLES_G
		{			
			HIDDEN;
			LONG FLUIDSIM_TRACEALGO_BUBBLE
			{
				CYCLE
				{
				FLUIDSIM_TRACEALGO_BUBBLE_EULER1ST;
				FLUIDSIM_TRACEALGO_BUBBLE_RUNGA2ND;
				FLUIDSIM_TRACEALGO_BUBBLE_RUNGA3RD;
				FLUIDSIM_TRACEALGO_BUBBLE_RUNGA4TH;
				}
			}
			LONG FLUIDSIM_SUBSTEPS_BUBBLE {MIN 0; MAX 1000;}
			BOOL FLUIDSIM_BUBBLEPARTICLES_CHECKADVECT {}
		}
	}
	GROUP ID_ADVANCED
	{		
		LONG FLUIDSIM_CACHE_MODE 
		{
			ANIM OFF;
			CYCLE
			{
				FLUIDSIM_CACHE_MODE_OFF;
				FLUIDSIM_CACHE_MODE_LOAD;
				FLUIDSIM_CACHE_MODE_SAVE;
			}
		}
		
		SEPARATOR{LINE;}

		GROUP
		{
			COLUMNS 3;
			BUTTON FLUIDSIM_CACHE_FILE {}
			BUTTON FLUIDSIM_CACHE_CLEAR {}
			BUTTON FLUIDSIM_CACHE_SINGLEFRAME {}			
		}
		BOOL   FLUIDSIM_CACHEPREVIEW {HIDDEN;}
		STRING FLUIDSIM_CACHE_FILENAME {ANIM OFF;}
		STRING FLUIDSIM_CACHE_FILENAME_NAME {ANIM OFF;}
		
		SEPARATOR{}
				
		GROUP FLUIDSIM_CACHERENDER_SID
		{
			DEFAULT 1;
			BOOL FLUIDSIM_CACHE_USECACHE_RAM {ANIM OFF; HIDDEN;}
			BOOL FLUIDSIM_CACHE_USECACHE_EXTERNAL {ANIM OFF;}
			BOOL FLUIDSIM_CACHE_USECACHE_LOADSAVE {ANIM OFF;}
			GROUP
			{
				COLUMNS 2;
				LONG FLUIDSIM_CACHE_CFRAME {MIN -1; }
				LONG FLUIDSIM_CACHE_OFFSET { }
			}
			SEPARATOR{LINE;}
			GROUP FLUIDSIM_CACHE_CHANNELS_SID
			{
				COLUMNS 2;
				BOOL FLUIDSIM_CACHE_FLUID {}
				BOOL FLUIDSIM_CACHE_SMOKE {}
				BOOL FLUIDSIM_CACHE_HEAT {}
				BOOL FLUIDSIM_CACHE_FUEL {}
				BOOL FLUIDSIM_CACHE_FIRE {}
				BOOL FLUIDSIM_CACHE_COLOR {}
				BOOL FLUIDSIM_CACHE_FLOWMAP {}
				BOOL FLUIDSIM_CACHE_FP {}
				BOOL FLUIDSIM_CACHE_SL {}
				BOOL FLUIDSIM_CACHE_VP {}
				BOOL FLUIDSIM_CACHE_MP {}
				BOOL FLUIDSIM_CACHE_FL {}
				BOOL FLUIDSIM_CACHE_FOAM {}
				BOOL FLUIDSIM_CACHE_BUBBLES {HIDDEN;}
			}
			SEPARATOR{LINE;}
			
			STRING FLUIDSIM_CACHEFILE_INFO { CUSTOMGUI MULTISTRING; }
		}
		GROUP FLUIDSIM_CACHEEDITOR_SID
		{
			DEFAULT 1;
			LONG FLUIDSIM_CACHE_SAVEMODE 
			{
				ANIM OFF;
				CYCLE
				{
					//FLUIDSIM_CACHE_SAVEMODE_RAM;
					FLUIDSIM_CACHE_SAVEMODE_DISK;
					FLUIDSIM_CACHE_SAVEMODE_DISKRENDER;
				}
			}
			LONG FLUIDSIM_CACHE_SAVEFRAME 
			{
				ANIM OFF;
				CYCLE
				{
					FLUIDSIM_CACHE_SAVEFRAME_SIM;
					FLUIDSIM_CACHE_SAVEFRAME_C4D;
				}
			}
			BOOL FLUIDSIM_CACHE_SAVECACHE_COMPRESS {ANIM OFF; }
			SEPARATOR{LINE;}

			GROUP
			{
				COLUMNS 2;
				BOOL FLUIDSIM_CACHE_USECACHE_FLUID {ANIM OFF; }
				BOOL FLUIDSIM_CACHE_USECACHE_SMOKE {ANIM OFF; }
				BOOL FLUIDSIM_CACHE_USECACHE_HEAT {ANIM OFF; }
				BOOL FLUIDSIM_CACHE_USECACHE_FUEL {ANIM OFF; }
				BOOL FLUIDSIM_CACHE_USECACHE_FIRE {ANIM OFF; }
				BOOL FLUIDSIM_CACHE_USECACHE_COLOR {ANIM OFF; }
				BOOL FLUIDSIM_CACHE_USECACHE_FLOWMAP {ANIM OFF; }
				BOOL FLUIDSIM_CACHE_USECACHE_FP {ANIM OFF; }
				BOOL FLUIDSIM_CACHE_USECACHE_SL {ANIM OFF; }
				BOOL FLUIDSIM_CACHE_USECACHE_VP {ANIM OFF; }
				BOOL FLUIDSIM_CACHE_USECACHE_MP {ANIM OFF; }
				BOOL FLUIDSIM_CACHE_USECACHE_FL {ANIM OFF; }
				BOOL FLUIDSIM_CACHE_USECACHE_FOAM {ANIM OFF; }
				BOOL FLUIDSIM_CACHE_USECACHE_BUBBLES {ANIM OFF; HIDDEN;}
			}
		}
	}
	GROUP ID_DISPLAY_G
	{
		GROUP
		{
		COLUMNS 2;
		BOOL FLUIDSIM_DISPLAY_DRAWCONTAINER {}
		BOOL FLUIDSIM_DISPLAY_DRAWRENDERAREA {}
		BOOL FLUIDSIM_DISPLAY_DRAWGRIDTOP {}
		BOOL FLUIDSIM_DISPLAY_DRAWGRIDBOTTOM {}
		BOOL FLUIDSIM_DISPLAY_DRAWGRIDFRONT {}
		BOOL FLUIDSIM_DISPLAY_DRAWGRIDBACK {}
		BOOL FLUIDSIM_DISPLAY_DRAWGRIDLEFT {}
		BOOL FLUIDSIM_DISPLAY_DRAWGRIDRIGHT {}
		}
		SEPARATOR{LINE;}

		GROUP
		{
			COLUMNS 2;

			LONG FLUIDSIM_DISPLAY_DRAWFLUIDPARTICLES 
			{
				CYCLE
				{
					FLUIDSIM_DISPLAY_DRAWFLUIDPARTICLES_OFF;
					FLUIDSIM_DISPLAY_DRAWFLUIDPARTICLES_ON;
					FLUIDSIM_DISPLAY_DRAWFLUIDPARTICLES_COLOR;
				}
			}
			REAL FLUIDSIM_DISPLAY_FP_AMOUNT { MIN 1; MAX 100; UNIT PERCENT; }

			LONG FLUIDSIM_DISPLAY_DRAWLIQUIDPARTICLES 
			{
				CYCLE
				{
					FLUIDSIM_DISPLAY_DRAWLIQUIDPARTICLES_OFF;
					FLUIDSIM_DISPLAY_DRAWLIQUIDPARTICLES_ON;
					FLUIDSIM_DISPLAY_DRAWLIQUIDPARTICLES_ACC;
					FLUIDSIM_DISPLAY_DRAWLIQUIDPARTICLES_COLOR;
					FLUIDSIM_DISPLAY_DRAWLIQUIDPARTICLES_DENSITY;
					FLUIDSIM_DISPLAY_DRAWLIQUIDPARTICLES_VISCOSITY;
					FLUIDSIM_DISPLAY_DRAWLIQUIDPARTICLES_AGE;
					FLUIDSIM_DISPLAY_DRAWLIQUIDPARTICLES_CUSTOM;
				}
			}
			REAL FLUIDSIM_DISPLAY_FLIP_AMOUNT { MIN 1; MAX 100; UNIT PERCENT; }

			BOOL FLUIDSIM_DISPLAY_DRAWVORTEXPARTICLES {}
			REAL FLUIDSIM_DISPLAY_VP_AMOUNT { MIN 1; MAX 100; UNIT PERCENT; }

			BOOL FLUIDSIM_DISPLAY_DRAWFOAMPARTICLES {}
			REAL FLUIDSIM_DISPLAY_FOAM_AMOUNT { MIN 1; MAX 100; UNIT PERCENT; }

			BOOL FLUIDSIM_DISPLAY_DRAWBUBBLEPARTICLES {HIDDEN;}
			//REAL FLUIDSIM_DISPLAY_BUBBLE_AMOUNT { MIN 0; MAX 100; UNIT PERCENT; }

			BOOL FLUIDSIM_DISPLAY_DRAWSPRAYPARTICLES {HIDDEN;}
		}
		SEPARATOR{LINE;}

		GROUP
		{
			LONG FLUIDSIM_DISPLAY_SLICE_CHANNEL
			{
				CYCLE
				{
					FLUIDSIM_DISPLAY_SLICE_CHANNEL_OFF;
					FLUIDSIM_DISPLAY_SLICE_CHANNEL_SMOKE;
					FLUIDSIM_DISPLAY_SLICE_CHANNEL_TEMPERATURE;
					FLUIDSIM_DISPLAY_SLICE_CHANNEL_FUEL;
					FLUIDSIM_DISPLAY_SLICE_CHANNEL_FIRE;
					FLUIDSIM_DISPLAY_SLICE_CHANNEL_COLOR;
					FLUIDSIM_DISPLAY_SLICE_CHANNEL_GRIDMEMORY;
					FLUIDSIM_DISPLAY_SLICE_CHANNEL_VORTICITY;
					//FLUIDSIM_DISPLAY_SLICE_CHANNEL_PRESSURE;
					FLUIDSIM_DISPLAY_SLICE_CHANNEL_VISCOSITY;
					FLUIDSIM_DISPLAY_SLICE_CHANNEL_VDENSITY;
					FLUIDSIM_DISPLAY_SLICE_CHANNEL_SDF;
				}
			}
			LONG FLUIDSIM_DISPLAY_SLICE_AXIS
			{
				CYCLE
				{
					FLUIDSIM_DISPLAY_SLICE_AXIS_X;
					FLUIDSIM_DISPLAY_SLICE_AXIS_Y;
					FLUIDSIM_DISPLAY_SLICE_AXIS_Z;
				}
			}
			REAL FLUIDSIM_DISPLAY_SLICE_POS {MIN 0; MAX 100; UNIT PERCENT; CUSTOMGUI REALSLIDER;}
			GRADIENT FLUIDSIM_DISPLAY_SLICE_GRAD {ANIM ON;}
			
			SEPARATOR{LINE;}

			BOOL FLUIDSIM_DISPLAY_DRAWFLUIDMOTION {}
			BOOL FLUIDSIM_DISPLAY_DRAWOBSTACLES {}		
		}
		LONG FLUIDSIM_DEBUG_VOL
		{
			HIDDEN;
			CYCLE
			{
			FLUIDSIM_DEBUG_VOL_UVOL;
			FLUIDSIM_DEBUG_VOL_VVOL;
			FLUIDSIM_DEBUG_VOL_WVOL;
			FLUIDSIM_DEBUG_VOL_T12VOL;
			FLUIDSIM_DEBUG_VOL_T13VOL;
			FLUIDSIM_DEBUG_VOL_T23VOL;
			FLUIDSIM_DEBUG_VOL_CVOL;
			}
		}
	}
}